<?php //aaea6596775788bb8b932077251fbe6b
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphTo;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\Models\_IH_Advertisement_C;
    use LaravelIdea\Helper\App\Models\_IH_Advertisement_QB;
    use LaravelIdea\Helper\App\Models\_IH_Article_C;
    use LaravelIdea\Helper\App\Models\_IH_Article_QB;
    use LaravelIdea\Helper\App\Models\_IH_Broadcast_C;
    use LaravelIdea\Helper\App\Models\_IH_Broadcast_QB;
    use LaravelIdea\Helper\App\Models\_IH_Collection_C;
    use LaravelIdea\Helper\App\Models\_IH_Collection_QB;
    use LaravelIdea\Helper\App\Models\_IH_Comment_C;
    use LaravelIdea\Helper\App\Models\_IH_Comment_QB;
    use LaravelIdea\Helper\App\Models\_IH_Community_C;
    use LaravelIdea\Helper\App\Models\_IH_Community_QB;
    use LaravelIdea\Helper\App\Models\_IH_Country_C;
    use LaravelIdea\Helper\App\Models\_IH_Country_QB;
    use LaravelIdea\Helper\App\Models\_IH_Coupon_C;
    use LaravelIdea\Helper\App\Models\_IH_Coupon_QB;
    use LaravelIdea\Helper\App\Models\_IH_Genre_C;
    use LaravelIdea\Helper\App\Models\_IH_Genre_QB;
    use LaravelIdea\Helper\App\Models\_IH_Language_C;
    use LaravelIdea\Helper\App\Models\_IH_Language_QB;
    use LaravelIdea\Helper\App\Models\_IH_Log_C;
    use LaravelIdea\Helper\App\Models\_IH_Log_QB;
    use LaravelIdea\Helper\App\Models\_IH_Menu_C;
    use LaravelIdea\Helper\App\Models\_IH_Menu_QB;
    use LaravelIdea\Helper\App\Models\_IH_Module_C;
    use LaravelIdea\Helper\App\Models\_IH_Module_QB;
    use LaravelIdea\Helper\App\Models\_IH_Page_C;
    use LaravelIdea\Helper\App\Models\_IH_Page_QB;
    use LaravelIdea\Helper\App\Models\_IH_Payment_C;
    use LaravelIdea\Helper\App\Models\_IH_Payment_QB;
    use LaravelIdea\Helper\App\Models\_IH_People_C;
    use LaravelIdea\Helper\App\Models\_IH_People_QB;
    use LaravelIdea\Helper\App\Models\_IH_Plan_C;
    use LaravelIdea\Helper\App\Models\_IH_Plan_QB;
    use LaravelIdea\Helper\App\Models\_IH_PostEpisode_C;
    use LaravelIdea\Helper\App\Models\_IH_PostEpisode_QB;
    use LaravelIdea\Helper\App\Models\_IH_PostPeople_C;
    use LaravelIdea\Helper\App\Models\_IH_PostPeople_QB;
    use LaravelIdea\Helper\App\Models\_IH_PostSeason_C;
    use LaravelIdea\Helper\App\Models\_IH_PostSeason_QB;
    use LaravelIdea\Helper\App\Models\_IH_PostSubtitle_C;
    use LaravelIdea\Helper\App\Models\_IH_PostSubtitle_QB;
    use LaravelIdea\Helper\App\Models\_IH_PostVideo_C;
    use LaravelIdea\Helper\App\Models\_IH_PostVideo_QB;
    use LaravelIdea\Helper\App\Models\_IH_Post_C;
    use LaravelIdea\Helper\App\Models\_IH_Post_QB;
    use LaravelIdea\Helper\App\Models\_IH_Reaction_C;
    use LaravelIdea\Helper\App\Models\_IH_Reaction_QB;
    use LaravelIdea\Helper\App\Models\_IH_Report_C;
    use LaravelIdea\Helper\App\Models\_IH_Report_QB;
    use LaravelIdea\Helper\App\Models\_IH_RequestPost_C;
    use LaravelIdea\Helper\App\Models\_IH_RequestPost_QB;
    use LaravelIdea\Helper\App\Models\_IH_Settings_C;
    use LaravelIdea\Helper\App\Models\_IH_Settings_QB;
    use LaravelIdea\Helper\App\Models\_IH_Tag_C;
    use LaravelIdea\Helper\App\Models\_IH_Tag_QB;
    use LaravelIdea\Helper\App\Models\_IH_Tax_C;
    use LaravelIdea\Helper\App\Models\_IH_Tax_QB;
    use LaravelIdea\Helper\App\Models\_IH_Tool_C;
    use LaravelIdea\Helper\App\Models\_IH_Tool_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\App\Models\_IH_Watchlist_C;
    use LaravelIdea\Helper\App\Models\_IH_Watchlist_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $body
     * @property string $user_hide
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Advertisement_QB onWriteConnection()
     * @method _IH_Advertisement_QB newQuery()
     * @method static _IH_Advertisement_QB on(null|string $connection = null)
     * @method static _IH_Advertisement_QB query()
     * @method static _IH_Advertisement_QB with(array|string $relations)
     * @method _IH_Advertisement_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Advertisement_C|Advertisement[] all()
     * @mixin _IH_Advertisement_QB
     */
    class Advertisement extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string $description
     * @property string $body
     * @property string|null $image
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property string|null $featured
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $cover_url attribute
     * @property-read string $image_url attribute
     * @property _IH_Tag_C|Tag[] $tags
     * @property-read int $tags_count
     * @method BelongsToMany|_IH_Tag_QB tags()
     * @method static _IH_Article_QB onWriteConnection()
     * @method _IH_Article_QB newQuery()
     * @method static _IH_Article_QB on(null|string $connection = null)
     * @method static _IH_Article_QB query()
     * @method static _IH_Article_QB with(array|string $relations)
     * @method _IH_Article_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Article_C|Article[] all()
     * @foreignLinks 
     * @mixin _IH_Article_QB
     */
    class Article extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string|null $overview
     * @property string|null $image
     * @property string|null $cover
     * @property mixed|null $arguments
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property int|null $view
     * @property string $featured
     * @property string $member
     * @property string $comment
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $cover_url attribute
     * @property-read string $image_url attribute
     * @property _IH_Comment_C|Comment[] $comments
     * @property-read int $comments_count
     * @method MorphToMany|_IH_Comment_QB comments()
     * @property _IH_Reaction_C|Reaction[] $dislikes
     * @property-read int $dislikes_count
     * @method MorphToMany|_IH_Reaction_QB dislikes()
     * @property _IH_Reaction_C|Reaction[] $getReaction
     * @property-read int $get_reaction_count
     * @method MorphToMany|_IH_Reaction_QB getReaction()
     * @property Model $isReactionBy
     * @method MorphTo isReactionBy()
     * @property _IH_Reaction_C|Reaction[] $likes
     * @property-read int $likes_count
     * @method MorphToMany|_IH_Reaction_QB likes()
     * @property Model $reaction
     * @method MorphTo reaction()
     * @property _IH_Reaction_C|Reaction[] $reactions
     * @property-read int $reactions_count
     * @method MorphToMany|_IH_Reaction_QB reactions()
     * @property _IH_Report_C|Report[] $report
     * @property-read int $report_count
     * @method MorphToMany|_IH_Report_QB report()
     * @property _IH_PostVideo_C|PostVideo[] $videos
     * @property-read int $videos_count
     * @method MorphToMany|_IH_PostVideo_QB videos()
     * @method static _IH_Broadcast_QB onWriteConnection()
     * @method _IH_Broadcast_QB newQuery()
     * @method static _IH_Broadcast_QB on(null|string $connection = null)
     * @method static _IH_Broadcast_QB query()
     * @method static _IH_Broadcast_QB with(array|string $relations)
     * @method _IH_Broadcast_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Broadcast_C|Broadcast[] all()
     * @mixin _IH_Broadcast_QB
     */
    class Broadcast extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string $featured
     * @property _IH_Post_C|Post[] $posts
     * @property-read int $posts_count
     * @method BelongsToMany|_IH_Post_QB posts()
     * @property _IH_Post_C|Post[] $postsLimited
     * @property-read int $posts_limited_count
     * @method BelongsToMany|_IH_Post_QB postsLimited()
     * @method static _IH_Collection_QB onWriteConnection()
     * @method _IH_Collection_QB newQuery()
     * @method static _IH_Collection_QB on(null|string $connection = null)
     * @method static _IH_Collection_QB query()
     * @method static _IH_Collection_QB with(array|string $relations)
     * @method _IH_Collection_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Collection_C|Collection[] all()
     * @foreignLinks 
     * @mixin _IH_Collection_QB
     */
    class Collection extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int|null $parent_id
     * @property string $body
     * @property int $commentable_id
     * @property string $commentable_type
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Comment_C|Comment[] $children
     * @property-read int $children_count
     * @method HasMany|_IH_Comment_QB children()
     * @property Model $commentable
     * @method MorphTo commentable()
     * @property _IH_Reaction_C|Reaction[] $dislikes
     * @property-read int $dislikes_count
     * @method MorphToMany|_IH_Reaction_QB dislikes()
     * @property _IH_Reaction_C|Reaction[] $isLiked
     * @property-read int $is_liked_count
     * @method MorphToMany|_IH_Reaction_QB isLiked()
     * @property _IH_Reaction_C|Reaction[] $likes
     * @property-read int $likes_count
     * @method MorphToMany|_IH_Reaction_QB likes()
     * @property _IH_Reaction_C|Reaction[] $removeLike
     * @property-read int $remove_like_count
     * @method MorphToMany|_IH_Reaction_QB removeLike()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Comment_QB onWriteConnection()
     * @method _IH_Comment_QB newQuery()
     * @method static _IH_Comment_QB on(null|string $connection = null)
     * @method static _IH_Comment_QB query()
     * @method static _IH_Comment_QB with(array|string $relations)
     * @method _IH_Comment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Comment_C|Comment[] all()
     * @ownLinks user_id,\App\Models\User,id|parent_id,\App\Models\Comment,id
     * @foreignLinks id,\App\Models\Comment,parent_id
     * @mixin _IH_Comment_QB
     */
    class Comment extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int|null $post_id
     * @property string $title
     * @property string $slug
     * @property string|null $description
     * @property string $comment
     * @property string $featured
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read int $comment_count
     * @method MorphToMany|_IH_Comment_QB comment()
     * @property _IH_Comment_C|Comment[] $comments
     * @property-read int $comments_count
     * @method MorphToMany|_IH_Comment_QB comments()
     * @property Post|null $post
     * @method BelongsTo|_IH_Post_QB post()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Community_QB onWriteConnection()
     * @method _IH_Community_QB newQuery()
     * @method static _IH_Community_QB on(null|string $connection = null)
     * @method static _IH_Community_QB query()
     * @method static _IH_Community_QB with(array|string $relations)
     * @method _IH_Community_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Community_C|Community[] all()
     * @ownLinks user_id,\App\Models\User,id|post_id,\Cviebrock\EloquentSluggable\Tests\Models\PostNotSluggable,id
     * @mixin _IH_Community_QB
     */
    class Community extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property string $code
     * @property string|null $flag
     * @property string|null $subtitle
     * @property string|null $filter
     * @method static _IH_Country_QB onWriteConnection()
     * @method _IH_Country_QB newQuery()
     * @method static _IH_Country_QB on(null|string $connection = null)
     * @method static _IH_Country_QB query()
     * @method static _IH_Country_QB with(array|string $relations)
     * @method _IH_Country_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Country_C|Country[] all()
     * @foreignLinks id,\App\Models\PostSubtitle,country_id|id,\Cviebrock\EloquentSluggable\Tests\Models\PostNotSluggable,country_id
     * @mixin _IH_Country_QB
     */
    class Country extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $code
     * @property int|null $percentage
     * @property int|null $quantity
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @method static _IH_Coupon_QB onWriteConnection()
     * @method _IH_Coupon_QB newQuery()
     * @method static _IH_Coupon_QB on(null|string $connection = null)
     * @method static _IH_Coupon_QB query()
     * @method static _IH_Coupon_QB with(array|string $relations)
     * @method _IH_Coupon_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Coupon_C|Coupon[] all()
     * @mixin _IH_Coupon_QB
     */
    class Coupon extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string|null $description
     * @property string|null $icon
     * @property string|null $color
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property string|null $featured
     * @property string|null $footer
     * @property Post $post
     * @method BelongsTo|_IH_Post_QB post()
     * @property _IH_Post_C|Post[] $posts
     * @property-read int $posts_count
     * @method BelongsToMany|_IH_Post_QB posts()
     * @method static _IH_Genre_QB onWriteConnection()
     * @method _IH_Genre_QB newQuery()
     * @method static _IH_Genre_QB on(null|string $connection = null)
     * @method static _IH_Genre_QB query()
     * @method static _IH_Genre_QB with(array|string $relations)
     * @method _IH_Genre_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Genre_C|Genre[] all()
     * @foreignLinks 
     * @mixin _IH_Genre_QB
     */
    class Genre extends Model {}
    
    /**
     * @property int $id
     * @property string $code
     * @property string $direction
     * @property string $name
     * @method static _IH_Language_QB onWriteConnection()
     * @method _IH_Language_QB newQuery()
     * @method static _IH_Language_QB on(null|string $connection = null)
     * @method static _IH_Language_QB query()
     * @method static _IH_Language_QB with(array|string $relations)
     * @method _IH_Language_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Language_C|Language[] all()
     * @mixin _IH_Language_QB
     */
    class Language extends Model {}
    
    /**
     * @property int $user_id
     * @property int $postable_id
     * @property string $postable_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Model $postable
     * @method MorphTo postable()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Log_QB onWriteConnection()
     * @method _IH_Log_QB newQuery()
     * @method static _IH_Log_QB on(null|string $connection = null)
     * @method static _IH_Log_QB query()
     * @method static _IH_Log_QB with(array|string $relations)
     * @method _IH_Log_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Log_C|Log[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Log_QB
     */
    class Log extends Model {}
    
    /**
     * @property int $id
     * @property string|null $layout
     * @property string|null $title
     * @property string|null $url
     * @property string|null $route
     * @property string|null $icon
     * @property int $sortable
     * @property string|null $static
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Menu_QB onWriteConnection()
     * @method _IH_Menu_QB newQuery()
     * @method static _IH_Menu_QB on(null|string $connection = null)
     * @method static _IH_Menu_QB query()
     * @method static _IH_Menu_QB with(array|string $relations)
     * @method _IH_Menu_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Menu_C|Menu[] all()
     * @mixin _IH_Menu_QB
     */
    class Menu extends Model {}
    
    /**
     * @property int $id
     * @property string $page
     * @property string $title
     * @property string $slug
     * @property mixed|null $arguments
     * @property int $sortable
     * @property string|null $status
     * @method static _IH_Module_QB onWriteConnection()
     * @method _IH_Module_QB newQuery()
     * @method static _IH_Module_QB on(null|string $connection = null)
     * @method static _IH_Module_QB query()
     * @method static _IH_Module_QB with(array|string $relations)
     * @method _IH_Module_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Module_C|Module[] all()
     * @mixin _IH_Module_QB
     */
    class Module extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string|null $description
     * @property string|null $body
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property string|null $featured
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Page_QB onWriteConnection()
     * @method _IH_Page_QB newQuery()
     * @method static _IH_Page_QB on(null|string $connection = null)
     * @method static _IH_Page_QB query()
     * @method static _IH_Page_QB with(array|string $relations)
     * @method _IH_Page_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Page_C|Page[] all()
     * @mixin _IH_Page_QB
     */
    class Page extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $plan_id
     * @property string $payment_id
     * @property string $payment_method
     * @property string $amount
     * @property string $currency
     * @property string $interval
     * @property string $status
     * @property string|null $coupons
     * @property string|null $taxes
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Plan $plan
     * @method BelongsTo|_IH_Plan_QB plan()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Payment_QB onWriteConnection()
     * @method _IH_Payment_QB newQuery()
     * @method static _IH_Payment_QB on(null|string $connection = null)
     * @method static _IH_Payment_QB query()
     * @method static _IH_Payment_QB with(array|string $relations)
     * @method _IH_Payment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Payment_C|Payment[] all()
     * @ownLinks user_id,\App\Models\User,id|plan_id,\App\Models\Plan,id
     * @mixin _IH_Payment_QB
     */
    class Payment extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property string|null $image
     * @property string|null $bio
     * @property string|null $gender
     * @property Carbon|null $birthday
     * @property Carbon|null $death_date
     * @property mixed|null $arguments
     * @property string|null $imdb_id
     * @property string|null $tmdb_id
     * @property string|null $tmdb_image
     * @property string|null $featured
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $image_url attribute
     * @property _IH_Post_C|Post[] $posts
     * @property-read int $posts_count
     * @method BelongsToMany|_IH_Post_QB posts()
     * @method static _IH_People_QB onWriteConnection()
     * @method _IH_People_QB newQuery()
     * @method static _IH_People_QB on(null|string $connection = null)
     * @method static _IH_People_QB query()
     * @method static _IH_People_QB with(array|string $relations)
     * @method _IH_People_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_People_C|People[] all()
     * @mixin _IH_People_QB
     */
    class People extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $description
     * @property string $currency
     * @property string|null $interval
     * @property int|null $price
     * @property int|null $sorting
     * @property mixed|null $coupons
     * @property mixed|null $taxes
     * @property string|null $featured
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Plan_QB onWriteConnection()
     * @method _IH_Plan_QB newQuery()
     * @method static _IH_Plan_QB on(null|string $connection = null)
     * @method static _IH_Plan_QB query()
     * @method static _IH_Plan_QB with(array|string $relations)
     * @method _IH_Plan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Plan_C|Plan[] all()
     * @foreignLinks id,\App\Models\User,plan_id|id,\App\Models\Payment,plan_id
     * @mixin _IH_Plan_QB
     */
    class Plan extends Model {}
    
    /**
     * @property int $id
     * @property string $type
     * @property string $title
     * @property string $slug
     * @property string $title_sub
     * @property string|null $tagline
     * @property string|null $overview
     * @property string|null $image
     * @property string|null $cover
     * @property string|null $slide
     * @property string|null $story
     * @property string|null $tmdb_image
     * @property string|null $collection
     * @property Carbon|null $release_date
     * @property string|null $runtime
     * @property string|null $vote_average
     * @property int|null $country_id
     * @property string|null $trailer
     * @property string|null $quality
     * @property mixed|null $arguments
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property string|null $imdb_id
     * @property string|null $tmdb_id
     * @property int|null $view
     * @property string $featured
     * @property string $slider
     * @property string $member
     * @property string $comment
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $platform_id
     * @property-read string $cover_url attribute
     * @property-read string $image_url attribute
     * @property-read string $slide_url attribute
     * @property-read string $story_url attribute
     * @property _IH_Comment_C|Comment[] $comments
     * @property-read int $comments_count
     * @method MorphToMany|_IH_Comment_QB comments()
     * @property Country|null $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property _IH_Reaction_C|Reaction[] $dislikes
     * @property-read int $dislikes_count
     * @method MorphToMany|_IH_Reaction_QB dislikes()
     * @property _IH_PostVideo_C|PostVideo[] $downloads
     * @property-read int $downloads_count
     * @method MorphToMany|_IH_PostVideo_QB downloads()
     * @property _IH_PostEpisode_C|PostEpisode[] $episodes
     * @property-read int $episodes_count
     * @method HasMany|_IH_PostEpisode_QB episodes()
     * @property _IH_Genre_C|Genre[] $genres
     * @property-read int $genres_count
     * @method BelongsToMany|_IH_Genre_QB genres()
     * @property _IH_Reaction_C|Reaction[] $getReaction
     * @property-read int $get_reaction_count
     * @method MorphToMany|_IH_Reaction_QB getReaction()
     * @property Model $isReactionBy
     * @method MorphTo isReactionBy()
     * @property _IH_Reaction_C|Reaction[] $likes
     * @property-read int $likes_count
     * @method MorphToMany|_IH_Reaction_QB likes()
     * @property _IH_Log_C|Log[] $logs
     * @property-read int $logs_count
     * @method MorphToMany|_IH_Log_QB logs()
     * @property _IH_People_C|People[] $peoples
     * @property-read int $peoples_count
     * @method BelongsToMany|_IH_People_QB peoples()
     * @property Model $reaction
     * @method MorphTo reaction()
     * @property _IH_Reaction_C|Reaction[] $reactions
     * @property-read int $reactions_count
     * @method MorphToMany|_IH_Reaction_QB reactions()
     * @property _IH_Report_C|Report[] $report
     * @property-read int $report_count
     * @method MorphToMany|_IH_Report_QB report()
     * @property _IH_PostSeason_C|PostSeason[] $seasons
     * @property-read int $seasons_count
     * @method HasMany|_IH_PostSeason_QB seasons()
     * @property _IH_PostSubtitle_C|PostSubtitle[] $subtitles
     * @property-read int $subtitles_count
     * @method MorphToMany|_IH_PostSubtitle_QB subtitles()
     * @property _IH_Tag_C|Tag[] $tags
     * @property-read int $tags_count
     * @method BelongsToMany|_IH_Tag_QB tags()
     * @property _IH_PostVideo_C|PostVideo[] $videos
     * @property-read int $videos_count
     * @method MorphToMany|_IH_PostVideo_QB videos()
     * @property _IH_User_C|User[] $watchlist
     * @property-read int $watchlist_count
     * @method MorphToMany|_IH_User_QB watchlist()
     * @method static _IH_Post_QB onWriteConnection()
     * @method _IH_Post_QB newQuery()
     * @method static _IH_Post_QB on(null|string $connection = null)
     * @method static _IH_Post_QB query()
     * @method static _IH_Post_QB with(array|string $relations)
     * @method _IH_Post_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Post_C|Post[] all()
     * @ownLinks country_id,\App\Models\Country,id
     * @foreignLinks id,\App\Models\PostSeason,post_id|id,\App\Models\PostEpisode,post_id|id,\App\Models\PostPeople,post_id|id,\App\Models\Community,post_id
     * @mixin _IH_Post_QB
     */
    class Post extends Model {}
    
    /**
     * @property int $id
     * @property int $post_id
     * @property int $post_season_id
     * @property string|null $season_number
     * @property string|null $name
     * @property string|null $episode_number
     * @property string|null $overview
     * @property string|null $image
     * @property string|null $runtime
     * @property string|null $quality
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property string|null $tmdb_id
     * @property string|null $tmdb_image
     * @property int|null $view
     * @property string $featured
     * @property string $comment
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $image_url attribute
     * @property _IH_Comment_C|Comment[] $comments
     * @property-read int $comments_count
     * @method MorphToMany|_IH_Comment_QB comments()
     * @property _IH_Reaction_C|Reaction[] $dislikes
     * @property-read int $dislikes_count
     * @method MorphToMany|_IH_Reaction_QB dislikes()
     * @property _IH_PostVideo_C|PostVideo[] $downloads
     * @property-read int $downloads_count
     * @method MorphToMany|_IH_PostVideo_QB downloads()
     * @property _IH_Reaction_C|Reaction[] $getReaction
     * @property-read int $get_reaction_count
     * @method MorphToMany|_IH_Reaction_QB getReaction()
     * @property _IH_Log_C|Log[] $isLog
     * @property-read int $is_log_count
     * @method MorphToMany|_IH_Log_QB isLog()
     * @property Model $isReactionBy
     * @method MorphTo isReactionBy()
     * @property _IH_Reaction_C|Reaction[] $likes
     * @property-read int $likes_count
     * @method MorphToMany|_IH_Reaction_QB likes()
     * @property _IH_Log_C|Log[] $logs
     * @property-read int $logs_count
     * @method MorphToMany|_IH_Log_QB logs()
     * @property Post $post
     * @method BelongsTo|_IH_Post_QB post()
     * @property Model $reaction
     * @method MorphTo reaction()
     * @property _IH_Reaction_C|Reaction[] $reactions
     * @property-read int $reactions_count
     * @method MorphToMany|_IH_Reaction_QB reactions()
     * @property Report $report
     * @method MorphToMany|_IH_Report_QB report()
     * @property PostSeason $season
     * @method BelongsTo|_IH_PostSeason_QB season()
     * @property _IH_PostSubtitle_C|PostSubtitle[] $subtitles
     * @property-read int $subtitles_count
     * @method MorphToMany|_IH_PostSubtitle_QB subtitles()
     * @property _IH_PostVideo_C|PostVideo[] $videos
     * @property-read int $videos_count
     * @method MorphToMany|_IH_PostVideo_QB videos()
     * @property Watchlist $watchlist
     * @method MorphToMany|_IH_Watchlist_QB watchlist()
     * @method static _IH_PostEpisode_QB onWriteConnection()
     * @method _IH_PostEpisode_QB newQuery()
     * @method static _IH_PostEpisode_QB on(null|string $connection = null)
     * @method static _IH_PostEpisode_QB query()
     * @method static _IH_PostEpisode_QB with(array|string $relations)
     * @method _IH_PostEpisode_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PostEpisode_C|PostEpisode[] all()
     * @ownLinks post_id,\Cviebrock\EloquentSluggable\Tests\Models\PostNotSluggable,id|post_season_id,\App\Models\PostSeason,id
     * @mixin _IH_PostEpisode_QB
     */
    class PostEpisode extends Model {}
    
    /**
     * @property int $post_id
     * @property int $people_id
     * @property Post $post
     * @method BelongsTo|_IH_Post_QB post()
     * @method static _IH_PostPeople_QB onWriteConnection()
     * @method _IH_PostPeople_QB newQuery()
     * @method static _IH_PostPeople_QB on(null|string $connection = null)
     * @method static _IH_PostPeople_QB query()
     * @method static _IH_PostPeople_QB with(array|string $relations)
     * @method _IH_PostPeople_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PostPeople_C|PostPeople[] all()
     * @ownLinks post_id,\Cviebrock\EloquentSluggable\Tests\Models\PostNotSluggable,id
     * @mixin _IH_PostPeople_QB
     */
    class PostPeople extends Model {}
    
    /**
     * @property int $id
     * @property int $post_id
     * @property string $season_number
     * @property string|null $name
     * @property string|null $tmdb_id
     * @property _IH_PostEpisode_C|PostEpisode[] $episodes
     * @property-read int $episodes_count
     * @method HasMany|_IH_PostEpisode_QB episodes()
     * @property Post $post
     * @method BelongsTo|_IH_Post_QB post()
     * @method static _IH_PostSeason_QB onWriteConnection()
     * @method _IH_PostSeason_QB newQuery()
     * @method static _IH_PostSeason_QB on(null|string $connection = null)
     * @method static _IH_PostSeason_QB query()
     * @method static _IH_PostSeason_QB with(array|string $relations)
     * @method _IH_PostSeason_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PostSeason_C|PostSeason[] all()
     * @ownLinks post_id,\Cviebrock\EloquentSluggable\Tests\Models\PostNotSluggable,id
     * @foreignLinks id,\App\Models\PostEpisode,post_season_id
     * @mixin _IH_PostSeason_QB
     */
    class PostSeason extends Model {}
    
    /**
     * @property int $id
     * @property int $country_id
     * @property string $link
     * @property int $postable_id
     * @property string $postable_type
     * @property-read string $link_url attribute
     * @property Country $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property Model $postable
     * @method MorphTo postable()
     * @method static _IH_PostSubtitle_QB onWriteConnection()
     * @method _IH_PostSubtitle_QB newQuery()
     * @method static _IH_PostSubtitle_QB on(null|string $connection = null)
     * @method static _IH_PostSubtitle_QB query()
     * @method static _IH_PostSubtitle_QB with(array|string $relations)
     * @method _IH_PostSubtitle_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PostSubtitle_C|PostSubtitle[] all()
     * @ownLinks country_id,\App\Models\Country,id
     * @mixin _IH_PostSubtitle_QB
     */
    class PostSubtitle extends Model {}
    
    /**
     * @property int $id
     * @property int $postable_id
     * @property string $postable_type
     * @property string|null $label
     * @property string $type
     * @property string $link
     * @property Model $postable
     * @method MorphTo postable()
     * @method static _IH_PostVideo_QB onWriteConnection()
     * @method _IH_PostVideo_QB newQuery()
     * @method static _IH_PostVideo_QB on(null|string $connection = null)
     * @method static _IH_PostVideo_QB query()
     * @method static _IH_PostVideo_QB with(array|string $relations)
     * @method _IH_PostVideo_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PostVideo_C|PostVideo[] all()
     * @mixin _IH_PostVideo_QB
     */
    class PostVideo extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $reactable_id
     * @property string $reactable_type
     * @property string|null $reaction
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Comment_C|Comment[] $comment
     * @property-read int $comment_count
     * @method MorphToMany|_IH_Comment_QB comment()
     * @property _IH_PostEpisode_C|PostEpisode[] $episode
     * @property-read int $episode_count
     * @method MorphToMany|_IH_PostEpisode_QB episode()
     * @property _IH_Post_C|Post[] $post
     * @property-read int $post_count
     * @method MorphToMany|_IH_Post_QB post()
     * @property Model $reactable
     * @method MorphTo reactable()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Reaction_QB onWriteConnection()
     * @method _IH_Reaction_QB newQuery()
     * @method static _IH_Reaction_QB on(null|string $connection = null)
     * @method static _IH_Reaction_QB query()
     * @method static _IH_Reaction_QB with(array|string $relations)
     * @method _IH_Reaction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Reaction_C|Reaction[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Reaction_QB
     */
    class Reaction extends Model {}
    
    /**
     * @property int $id
     * @property string $type
     * @property int $postable_id
     * @property string $postable_type
     * @property string|null $description
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Model $postable
     * @method MorphTo postable()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Report_QB onWriteConnection()
     * @method _IH_Report_QB newQuery()
     * @method static _IH_Report_QB on(null|string $connection = null)
     * @method static _IH_Report_QB query()
     * @method static _IH_Report_QB with(array|string $relations)
     * @method _IH_Report_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Report_C|Report[] all()
     * @mixin _IH_Report_QB
     */
    class Report extends Model {}
    
    /**
     * @property int $id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_RequestPost_QB onWriteConnection()
     * @method _IH_RequestPost_QB newQuery()
     * @method static _IH_RequestPost_QB on(null|string $connection = null)
     * @method static _IH_RequestPost_QB query()
     * @method static _IH_RequestPost_QB with(array|string $relations)
     * @method _IH_RequestPost_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RequestPost_C|RequestPost[] all()
     * @mixin _IH_RequestPost_QB
     */
    class RequestPost extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $val
     * @property string $type
     * @method static _IH_Settings_QB onWriteConnection()
     * @method _IH_Settings_QB newQuery()
     * @method static _IH_Settings_QB on(null|string $connection = null)
     * @method static _IH_Settings_QB query()
     * @method static _IH_Settings_QB with(array|string $relations)
     * @method _IH_Settings_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Settings_C|Settings[] all()
     * @mixin _IH_Settings_QB
     */
    class Settings extends Model {}
    
    /**
     * @property int $id
     * @property string $tag
     * @property string $slug
     * @property string|null $type
     * @property _IH_Post_C|Post[] $posts
     * @property-read int $posts_count
     * @method BelongsToMany|_IH_Post_QB posts()
     * @method static _IH_Tag_QB onWriteConnection()
     * @method _IH_Tag_QB newQuery()
     * @method static _IH_Tag_QB on(null|string $connection = null)
     * @method static _IH_Tag_QB query()
     * @method static _IH_Tag_QB with(array|string $relations)
     * @method _IH_Tag_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Tag_C|Tag[] all()
     * @mixin _IH_Tag_QB
     */
    class Tag extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property bool $type
     * @property float $percentage
     * @property mixed|null $regions
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @method static _IH_Tax_QB onWriteConnection()
     * @method _IH_Tax_QB newQuery()
     * @method static _IH_Tax_QB on(null|string $connection = null)
     * @method static _IH_Tax_QB query()
     * @method static _IH_Tax_QB with(array|string $relations)
     * @method _IH_Tax_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Tax_C|Tax[] all()
     * @mixin _IH_Tax_QB
     */
    class Tax extends Model {}
    
    /**
     * @method static _IH_Tool_QB onWriteConnection()
     * @method _IH_Tool_QB newQuery()
     * @method static _IH_Tool_QB on(null|string $connection = null)
     * @method static _IH_Tool_QB query()
     * @method static _IH_Tool_QB with(array|string $relations)
     * @method _IH_Tool_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Tool_C|Tool[] all()
     * @mixin _IH_Tool_QB
     */
    class Tool extends Model {}
    
    /**
     * @property int $id
     * @property string $account_type
     * @property string $username
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property string $password
     * @property string|null $avatar
     * @property string|null $cover
     * @property string|null $about
     * @property mixed|null $billing
     * @property int|null $plan_id
     * @property string|null $plan_amount
     * @property string|null $plan_currency
     * @property string|null $plan_interval
     * @property string|null $plan_payment_method
     * @property string|null $plan_subscription_id
     * @property string|null $plan_subscription_status
     * @property Carbon|null $plan_created_at
     * @property Carbon|null $plan_recurring_at
     * @property Carbon|null $plan_ends_at
     * @property string|null $socialite_type
     * @property string|null $socialite_id
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read null $avatar_url attribute
     * @property-read null $cover_url attribute
     * @property _IH_Reaction_C|Reaction[] $like
     * @property-read int $like_count
     * @method HasMany|_IH_Reaction_QB like()
     * @property _IH_Reaction_C|Reaction[] $likes
     * @property-read int $likes_count
     * @method HasMany|_IH_Reaction_QB likes()
     * @property _IH_Log_C|Log[] $log
     * @property-read int $log_count
     * @method HasMany|_IH_Log_QB log()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property Plan|null $plan
     * @method BelongsTo|_IH_Plan_QB plan()
     * @property _IH_Reaction_C|Reaction[] $reaction
     * @property-read int $reaction_count
     * @method HasMany|_IH_Reaction_QB reaction()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @property _IH_Watchlist_C|Watchlist[] $watchlist
     * @property-read int $watchlist_count
     * @method HasMany|_IH_Watchlist_QB watchlist()
     * @property _IH_Post_C|Post[] $watchlister
     * @property-read int $watchlister_count
     * @method MorphToMany|_IH_Post_QB watchlister()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @ownLinks plan_id,\App\Models\Plan,id
     * @foreignLinks id,\App\Models\Comment,user_id|id,\App\Models\Reaction,user_id|id,\App\Models\Payment,user_id|id,\App\Models\Log,user_id|id,\App\Models\Community,user_id|id,\App\Models\Watchlist,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(array|callable|int|null $count = null, array|callable $state = [])
     */
    class User extends Model {}
    
    /**
     * @property int $user_id
     * @property int $postable_id
     * @property string $postable_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Post_C|Post[] $episode
     * @property-read int $episode_count
     * @method MorphToMany|_IH_Post_QB episode()
     * @property _IH_Post_C|Post[] $post
     * @property-read int $post_count
     * @method MorphToMany|_IH_Post_QB post()
     * @property Model $postable
     * @method MorphTo postable()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Watchlist_QB onWriteConnection()
     * @method _IH_Watchlist_QB newQuery()
     * @method static _IH_Watchlist_QB on(null|string $connection = null)
     * @method static _IH_Watchlist_QB query()
     * @method static _IH_Watchlist_QB with(array|string $relations)
     * @method _IH_Watchlist_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Watchlist_C|Watchlist[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Watchlist_QB
     */
    class Watchlist extends Model {}
}