<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e('Install'); ?></title>
    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/app.scss', 'resources/js/app.js']); ?>
    <style>
        :root {
            <?php $__currentLoopData = config('attr.colors.zinc'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo e('--color-gray-'.$color.':'.hexToRgb('#'.$value)); ?>;
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            --color-primary-500: <?php if(config('settings.color')): ?><?php echo e(hexToRgb(config('settings.color'))); ?><?php else: ?><?php echo e(hexToRgb('#8b5cf6')); ?><?php endif; ?>;
        }
    </style>
</head>
<body
    class="min-h-screen bg-white dark:bg-gray-950 flex flex-col relative">
<div
    class="relative before:absolute before:top-0 before:inset-x-0 before:bg-[url('../img/shape.svg')] before:bg-no-repeat before:bg-top before:w-full before:h-full before:-z-[1]  dark:before:opacity-10 my-8">
    <?php echo $__env->yieldContent('content'); ?>
</div>
</body>
</html>
<?php /**PATH C:\Users\mdeas\Downloads\Compressed\MovieSite\resources\views/layouts/install.blade.php ENDPATH**/ ?>