<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php if(isset($config['title'])): ?><?php echo e($config['title']); ?><?php else: ?><?php echo e(config('settings.title')); ?><?php endif; ?></title>
        <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('favicon/apple-touch-icon.png')); ?>">
        <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('favicon/favicon-32x32.png')); ?>">
        <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('favicon/favicon-16x16.png')); ?>">
        <link rel="manifest" href="<?php echo e(asset('site.webmanifest')); ?>">
        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')([
            'resources/scss/app.scss',
            'resources/js/app.js'
        ]); ?>
        <script>
            if (localStorage.getItem('dark-mode') == 'true' || !('dark-mode' in localStorage)) {
                document.querySelector('html').classList.add('dark');
            } else {
                document.querySelector('html').classList.remove('dark');
            }
        </script>
        <style>
            :root {

            <?php if(config('settings.palette')): ?>
                <?php $__currentLoopData = config('attr.colors.'.config('settings.palette')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e('--color-gray-'.$color.':'.hexToRgb('#'.$value)); ?>;
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <?php $__currentLoopData = config('attr.colors.zinc'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo e('--color-gray-'.$color.':'.hexToRgb('#'.$value)); ?>;
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
--color-primary-500: <?php if(config('settings.color')): ?><?php echo e(hexToRgb(config('settings.color'))); ?><?php else: ?><?php echo e(hexToRgb('#6366f1')); ?><?php endif; ?>;
            }
        </style>
    </head>
    <body class="min-h-screen bg-white dark:bg-gray-950" x-data="{'sidebarToggle': false, cookiePolicy: localStorage.getItem('cookiePolicy')}" x-bind:class="{ 'false': cookiePolicy }" x-init="$watch('cookiePolicy', val => localStorage.setItem('cookiePolicy', val))">

        <?php echo $__env->make('admin.partials.sidenav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="flex flex-col">
            <?php echo $__env->make('admin.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="w-full pb-8 md:px-8 lg:pl-72">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
        <script src="<?php echo e(asset('static/js/lazysizes.js')); ?>"></script>
        <?php echo $__env->yieldPushContent('javascript'); ?>
        <?php if (isset($component)) { $__componentOriginal339c7fedf680433726dbafc2f156956f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal339c7fedf680433726dbafc2f156956f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.ui.toast','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('ui.toast'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal339c7fedf680433726dbafc2f156956f)): ?>
<?php $attributes = $__attributesOriginal339c7fedf680433726dbafc2f156956f; ?>
<?php unset($__attributesOriginal339c7fedf680433726dbafc2f156956f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal339c7fedf680433726dbafc2f156956f)): ?>
<?php $component = $__componentOriginal339c7fedf680433726dbafc2f156956f; ?>
<?php unset($__componentOriginal339c7fedf680433726dbafc2f156956f); ?>
<?php endif; ?>
        <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

        <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scriptConfig(); ?>

    </body>
</html>
<?php /**PATH C:\Users\mdeas\Downloads\Compressed\MovieSite\resources\views/layouts/admin.blade.php ENDPATH**/ ?>