<link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('favicon/apple-touch-icon.png')); ?>">
<link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('favicon/favicon-32x32.png')); ?>">
<link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('favicon/favicon-16x16.png')); ?>">
<link rel="manifest" href="<?php echo e(asset('site.webmanifest')); ?>">
<link rel="sitemap" type="application/xml" title="Sitemap" href="<?php echo e(url('/sitemap.xml')); ?>">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<?php echo app('Illuminate\Foundation\Vite')(['resources/scss/app.scss', 'resources/js/app.js']); ?>

<!-- Structured Data for SEO -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebSite",
  "name": "<?php echo e(config('settings.title')); ?>",
  "url": "<?php echo e(url('/')); ?>",
  "description": "<?php echo e(config('settings.description')); ?>",
  "potentialAction": {
    "@type": "SearchAction",
    "target": "<?php echo e(url('/search/{search_term_string}')); ?>",
    "query-input": "required name=search_term_string"
  }
}
</script>

<style>
    :root {
    <?php if(config('settings.palette')): ?>
        <?php $__currentLoopData = config('attr.colors.'.config('settings.palette')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo e('--color-gray-'.$color.':'.hexToRgb('#'.$value)); ?>;
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <?php $__currentLoopData = config('attr.colors.zinc'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo e('--color-gray-'.$color.':'.hexToRgb('#'.$value)); ?>;
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
           --color-primary-500: <?php if(config('settings.color')): ?><?php echo e(hexToRgb(config('settings.color'))); ?><?php else: ?><?php echo e(hexToRgb('#8b5cf6')); ?><?php endif; ?>;
    }
</style>
<?php echo config('settings.custom_code'); ?>

<?php if(config('settings.onesignal_id')): ?>
    <script src="https://cdn.onesignal.com/sdks/OneSignalSDK.js" defer></script>
    <script>
        window.OneSignal = window.OneSignal || [];
        OneSignal.push(function () {
            OneSignal.init({
                appId: "<?php echo e(env('ONESIGNAL_APP_ID')); ?>"
            });
        });

        OneSignal.push(function () {
            OneSignal.showNativePrompt();
        });
    </script>
<?php endif; ?>
<?php /**PATH C:\Users\mdeas\Downloads\Compressed\MovieSite\resources\views/partials/head.blade.php ENDPATH**/ ?>