@extends('layouts.app')
@push('javascript')
    <script src="{{asset('static/js/swiper.js')}}"></script>
@endpush

@push('after-body')
    @include('components.landing-alert-modal')
@endpush

@section('content')
    <div class="custom-container">
        @foreach($modules as $module)
            @include('home.partials.'.$module->slug)
            @if($loop->index % 3 == 0)
                @include('partials.ads',['id'=> 4])
            @endif
        @endforeach
        
        @if(isset($customSections) && $customSections->count() > 0)
            @foreach($customSections as $customSection)
                @if(isset($listings['custom_section_'.$customSection->id]) && $listings['custom_section_'.$customSection->id]->count() > 0)
                    <x-ui.home-list
                        :listings="$listings['custom_section_'.$customSection->id]"
                        :module="$customSection"
                        layout="custom_section_{{$customSection->id}}"
                        card="post"
                        :heading="$customSection->title"
                        :moreUrl="$customSection->genres->count() > 0 ? route('genre', ['genre' => $customSection->genres->first()->slug]) : '#'" />
                @endif
            @endforeach
        @endif
        
        @if(config('settings.footer_description'))
            <div
                class="pb-6 lg:pb-10">{!! editor_preview(config('settings.footer_description')) !!}</div>
        @endif
    </div>
@endsection
