@php
    $features = json_decode(config('settings.landing_alert_features', '[]'), true);
    if (empty($features)) {
        $features = [
            ['icon' => 'film', 'text' => '4K Video'],
            ['icon' => 'ban', 'text' => 'No Ads'],
            ['icon' => 'download', 'text' => 'Offline Download'],
            ['icon' => 'star', 'text' => 'Exclusive Movies'],
        ];
    }
@endphp

@if(config('settings.landing_alert_enabled') == '1')
<style>
    #landing-modal-gradient {
        background: linear-gradient(135deg, #7c2d12 0%, #581c87 50%, #1e3a8a 100%);
        background: linear-gradient(135deg,
            rgba(127, 29, 29, 1) 0%,
            rgba(88, 28, 135, 1) 35%,
            rgba(59, 130, 246, 1) 100%
        );
    }

    #landing-modal-gradient::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg,
            #991b1b 0%,
            #6b21a8 40%,
            #1d4ed8 100%
        );
        opacity: 0.9;
        z-index: -1;
    }

    #landing-action-button {
        background: linear-gradient(90deg, #a855f7 0%, #ec4899 50%, #ef4444 100%) !important;
        box-shadow: 0 4px 15px rgba(236, 72, 153, 0.4);
    }

    #landing-action-button:hover {
        background: linear-gradient(90deg, #9333ea 0%, #db2777 50%, #dc2626 100%) !important;
        box-shadow: 0 6px 20px rgba(236, 72, 153, 0.6);
        transform: translateY(-1px);
    }
</style>

<div id="landing-alert-wrapper" class="fixed inset-0 hidden" style="z-index: 1">
    <div class="fixed inset-0 bg-black/70 backdrop-blur-sm transition-opacity" onclick="closeLandingAlert()"></div>

    <div class="fixed inset-0 flex items-center justify-center p-4">
        <div id="landing-modal-gradient" class="relative transform overflow-hidden rounded-2xl text-left shadow-2xl transition-all sm:my-8 sm:w-full sm:max-w-md w-full max-w-md mx-4" style="position: relative;">

            <!-- Close Button -->
            <button onclick="closeLandingAlert()" class="absolute right-3 top-3 text-gray-300 hover:text-white transition z-10">
                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
            
            <!-- Modal Content -->
            <div class="px-6 py-6 sm:px-8 sm:py-8">
                <!-- Title -->
                <h3 class="text-xl font-bold text-center text-white mb-6" id="modal-title">
                    {{ config('settings.landing_alert_title', 'Welcome to Moviebox !') }}
                </h3>

                <!-- Features Row -->
                <div class="flex justify-around items-start gap-2 flex-wrap mb-4">
                    @foreach($features as $feature)
                        <div class="flex flex-col items-center gap-1.5 flex-1 min-w-[60px]">
                            <div class="w-10 h-10 flex items-center justify-center">
                                @if(str_contains($feature['icon'], 'fa-') || str_starts_with($feature['icon'], 'fas ') || str_starts_with($feature['icon'], 'far ') || str_starts_with($feature['icon'], 'fab ') || str_starts_with($feature['icon'], 'fal ') || str_starts_with($feature['icon'], 'fat '))
                                    <i class="{{ $feature['icon'] }} text-white text-lg"></i>
                                @else
                                    <x-ui.icon name="{{ $feature['icon'] }}" class="w-5 h-5 text-white" stroke="currentColor" stroke-width="2"/>
                                @endif
                            </div>
                            <span class="text-xs text-white text-center leading-tight">
                                {{ $feature['text'] }}
                            </span>
                        </div>
                    @endforeach
                </div>

                <!-- Description -->
                @if(!empty(config('settings.landing_alert_description')))
                    <div class="mb-5 px-4 py-3 rounded-lg border border-white/20 bg-white/10 backdrop-blur-sm">
                        <div class="text-sm text-center text-white">
                            {!! config('settings.landing_alert_description', 'Get the best movie experience with our mobile app') !!}
                        </div>
                    </div>
                @endif

                <!-- Action Button -->
                @if(!empty(config('settings.landing_alert_button_link')))
                    <a href="{{ config('settings.landing_alert_button_link', '#') }}"
                       id="landing-action-button"
                       class="block w-full py-3 px-4 text-white font-semibold rounded-lg text-center transition-all duration-200 mb-3">
                        {{ config('settings.landing_alert_button_text', 'Download App') }}
                    </a>
                @endif

                <!-- Don't Show Today Button -->
                <button onclick="dontShowToday()" class="w-full py-2 text-sm text-gray-400 hover:text-gray-200 transition">
                    {{ __("Don't show it today") }}
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    // Check if user has already dismissed modal today
    document.addEventListener('DOMContentLoaded', function() {
        console.log('Landing Alert Enabled:', '{{ config('settings.landing_alert_enabled', '0') }}');
        checkAndShowModal();
    });

    function checkAndShowModal() {
        const today = new Date().toDateString();
        const dismissedDate = localStorage.getItem('landing_alert_dismissed_date');
        
        console.log('Checking modal - Today:', today, 'Dismissed:', dismissedDate, 'Should show:', dismissedDate !== today);
        
        if (dismissedDate !== today) {
            // Show modal with a slight delay
            setTimeout(function() {
                const modalWrapper = document.getElementById('landing-alert-wrapper');
                console.log('Modal wrapper element:', modalWrapper);
                if (modalWrapper) {
                    modalWrapper.classList.remove('hidden');
                    console.log('Modal shown');
                }
            }, 1000); // 1 second delay
        }
    }

    function closeLandingAlert() {
        const modalWrapper = document.getElementById('landing-alert-wrapper');
        console.log('closeLandingAlert called - Modal wrapper:', modalWrapper);
        if (modalWrapper) {
            modalWrapper.classList.add('hidden');
            console.log('Modal hidden - classes:', modalWrapper.className);
        }
    }

    function dontShowToday() {
        const today = new Date().toDateString();
        localStorage.setItem('landing_alert_dismissed_date', today);
        console.log('dontShowToday called - Set date to:', today);
        console.log('Current localStorage:', JSON.stringify(localStorage));
        closeLandingAlert();
    }

    // Close modal on Escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            closeLandingAlert();
        }
    });
</script>
@endif
