<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Settings;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add landing alert settings to the settings table
        $settings = [
            [
                'name' => 'landing_alert_enabled',
                'val' => '0',
            ],
            [
                'name' => 'landing_alert_title',
                'val' => 'Download Our App',
            ],
            [
                'name' => 'landing_alert_description',
                'val' => 'Get the best movie experience with our mobile app',
            ],
            [
                'name' => 'landing_alert_button_text',
                'val' => 'Download Now',
            ],
            [
                'name' => 'landing_alert_button_link',
                'val' => '#',
            ],
            [
                'name' => 'landing_alert_features',
                'val' => json_encode([
                    ['icon' => 'film', 'text' => '4K Video'],
                    ['icon' => 'ban', 'text' => 'No Ads'],
                    ['icon' => 'download', 'text' => 'Offline Download'],
                    ['icon' => 'star', 'text' => 'Exclusive Movies'],
                ]),
            ],
        ];

        foreach ($settings as $setting) {
            Settings::updateOrCreate(
                ['name' => $setting['name']],
                ['val' => $setting['val']]
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Settings::whereIn('name', [
            'landing_alert_enabled',
            'landing_alert_title',
            'landing_alert_description',
            'landing_alert_button_text',
            'landing_alert_button_link',
            'landing_alert_features',
        ])->delete();
    }
};
