<?php

namespace App\Livewire;

use Livewire\Component;

class WatchComponent extends Component
{
    public $cover;
    public $listing;
    public $videos = [];
    public $isPreloader = true;

    public function mount($listing)
    {
        if ($listing->type == 'movie') {
            $this->cover = $listing->coverurl;
        } elseif (isset($listing->post->type) AND $listing->post->type == 'tv') {
            $this->cover = $listing->post->coverurl;
        } else {
            $this->cover = $listing->coverurl;
        }
        foreach ($listing->videos as $video) {
            $this->videos[] = [
                'label' => $video->label ?? 'Stream',
                'type' => $video->type,
                'link' => route('embed', $video->id),
            ];
        }
        if ($listing->type == 'movie') {
            if (config('settings.vidsrc') and $listing->tmdb_id) {
                $this->videos[] = [
                    'label' => 'VidSrc',
                    'type' => 'embed',
                    'link' => 'https://vidsrc-embed.ru/embed/movie/' . $listing->tmdb_id,
                ];
            }
        } elseif (isset($listing->post->type) AND $listing->post->type == 'tv') {
            if (config('settings.vidsrc') and $listing->post->tmdb_id) {
                $this->videos[] = [
                    'label' => 'VidSrc',
                    'type' => 'embed',
                    'link' => 'https://vidsrc-embed.ru/embed/tv/' . $listing->post->tmdb_id . '/' . $listing->season_number . '/' . $listing->episode_number,
                ];
            }
        }
        if ($listing->type == 'movie') {
            if (config('settings.vidsrc') and $listing->tmdb_id) {
                $this->videos[] = [
                    'label' => 'Rock',
                    'type' => 'embed',
                    'link' => 'https://vidrock.net/movie/' . $listing->tmdb_id,
                ];
            }
        } elseif (isset($listing->post->type) AND $listing->post->type == 'tv') {
            if (config('settings.vidsrc') and $listing->post->tmdb_id) {
                $this->videos[] = [
                    'label' => 'Rock',
                    'type' => 'embed',
                    'link' => 'https://vidrock.net/tv/' . $listing->post->tmdb_id . '/' . $listing->season_number . '/' . $listing->episode_number,
                ];
            }
        }
        if ($listing->type == 'movie') {
            if (config('settings.vidsrc') and $listing->tmdb_id) {
                $this->videos[] = [
                    'label' => 'PRO',
                    'type' => 'embed',
                    'link' => 'https://vidlink.pro/movie/' . $listing->tmdb_id,
                ];
            }
        } elseif (isset($listing->post->type) AND $listing->post->type == 'tv') {
            if (config('settings.vidsrc') and $listing->post->tmdb_id) {
                $this->videos[] = [
                    'label' => 'PRO',
                    'type' => 'embed',
                    'link' => 'https://vidlink.pro/tv/' . $listing->post->tmdb_id . '/' . $listing->season_number . '/' . $listing->episode_number,
                ];
            }
        }
        if ($listing->type == 'movie') {
            if (config('settings.vidsrc') and $listing->tmdb_id) {
                $this->videos[] = [
                    'label' => 'VIP',
                    'type' => 'embed',
                    'link' => 'https://moviesapi.to/movie/' . $listing->tmdb_id,
                ];
            }
        } elseif (isset($listing->post->type) AND $listing->post->type == 'tv') {
            if (config('settings.vidsrc') and $listing->post->tmdb_id) {
                $this->videos[] = [
                    'label' => 'VIP',
                    'type' => 'embed',
                    'link' => 'https://moviesapi.to/tv/' . $listing->post->tmdb_id . '/' . $listing->season_number . '/' . $listing->episode_number,
                ];
            }
        }
        if ($listing->type == 'movie') {
            if (config('settings.vidsrc') and $listing->tmdb_id) {
                $this->videos[] = [
                    'label' => 'V3',
                    'type' => 'embed',
                    'link' => 'https://vidsrc.cc/v2/embed/movie/' . $listing->tmdb_id,
                ];
            }
        } elseif (isset($listing->post->type) AND $listing->post->type == 'tv') {
            if (config('settings.vidsrc') and $listing->post->tmdb_id) {
                $this->videos[] = [
                    'label' => 'V3',
                    'type' => 'embed',
                    'link' => 'https://vidsrc.cc/v2/embed/tv/' . $listing->post->tmdb_id . '/' . $listing->season_number . '/' . $listing->episode_number,
                ];
            }
        }
        if ($listing->type == 'movie') {
            if (config('settings.vidsrc') and $listing->tmdb_id) {
                $this->videos[] = [
                    'label' => 'ICU',
                    'type' => 'embed',
                    'link' => 'https://vidsrc.icu/embed/movie/' . $listing->tmdb_id,
                ];
            }
        } elseif (isset($listing->post->type) AND $listing->post->type == 'tv') {
            if (config('settings.vidsrc') and $listing->post->tmdb_id) {
                $this->videos[] = [
                    'label' => 'ICU',
                    'type' => 'embed',
                    'link' => 'https://vidsrc.icu/embed/tv/' . $listing->post->tmdb_id . '/' . $listing->season_number . '/' . $listing->episode_number,
                ];
            }
        }
        if ($listing->type == 'movie') {
            if (config('settings.vidsrc') and $listing->tmdb_id) {
                $this->videos[] = [
                    'label' => 'Auto',
                    'type' => 'embed',
                    'link' => 'https://player.autoembed.cc/embed/movie/' . $listing->tmdb_id,
                ];
            }
        } elseif (isset($listing->post->type) AND $listing->post->type == 'tv') {
            if (config('settings.vidsrc') and $listing->post->tmdb_id) {
                $this->videos[] = [
                    'label' => 'Auto',
                    'type' => 'embed',
                    'link' => 'https://player.autoembed.cc/embed/tv/' . $listing->post->tmdb_id . '/' . $listing->season_number . '/' . $listing->episode_number,
                ];
            }
        }
    }

    public function watching()
    {
        $this->isPreloader = false;
    }

    public function render()
    {
        return view('livewire.watch');
    }
}
