<?php

namespace App\Http\Middleware;

use Closure;

class CleanSitemapResponse
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $response = $next($request);

        // Only clean XML responses
        if ($response->headers->get('Content-Type') === 'text/xml') {
            $content = $response->getContent();
            
            // Remove any script tags that might be injected
            $content = preg_replace('/<script\b[^>]*>(.*?)<\/script>/is', '', $content);
            $content = preg_replace('/<script\b[^>]*\/>/is', '', $content);
            
            // Remove any other unwanted HTML tags
            $content = preg_replace('/<[^>]+script[^>]*>/is', '', $content);
            
            $response->setContent($content);
        }

        return $response;
    }
}
