<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Settings;
use Illuminate\Support\Facades\Cache;

class LandingAlertController extends Controller
{
    public function index()
    {
        $config = [
            'title' => __('Landing Alert'),
            'nav' => 'landing-alert',
        ];

        return view('admin.landing-alert.index', compact('config'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'landing_alert_title' => 'required|string|max:255',
            'landing_alert_description' => 'required|string|max:500',
            'landing_alert_button_text' => 'required|string|max:100',
            'landing_alert_button_link' => 'nullable|url',
            'landing_alert_enabled' => 'nullable|boolean',
            'features' => 'nullable|array',
            'features.*.icon' => 'required|string',
            'features.*.text' => 'required|string|max:50',
        ]);

        // Update enabled status
        update_settings('landing_alert_enabled', $request->has('landing_alert_enabled') ? '1' : '0');

        // Update basic settings
        update_settings('landing_alert_title', $request->landing_alert_title);
        update_settings('landing_alert_description', $request->landing_alert_description);
        update_settings('landing_alert_button_text', $request->landing_alert_button_text);
        update_settings('landing_alert_button_link', $request->landing_alert_button_link ?? '');

        // Update features
        if ($request->has('features') && is_array($request->features)) {
            $features = [];
            foreach ($request->features as $feature) {
                if (!empty($feature['icon']) && !empty($feature['text'])) {
                    $features[] = [
                        'icon' => $feature['icon'],
                        'text' => $feature['text'],
                    ];
                }
            }
            update_settings('landing_alert_features', json_encode($features));
        }

        // Clear cache to ensure settings are updated
        Cache::forget('settings');
        Cache::flush();

        return redirect()->back()->with('success', __('Landing Alert settings updated successfully'));
    }
}
